import com.phidgets.*;
import com.phidgets.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PressureController4 extends JFrame {
	private InterfaceKitPhidget	interfaceKit;
	private int pressureIndex= 1;	// Analog input port connected to sensor
	private PressureView4 pv;
	
	public static void main(String[] args) {
		PressureController4 pc = new PressureController4();
		pc.pack();
		pc.setVisible(true);
		pc.openIntfcKit();
	}

	public PressureController4() {
		pv = new PressureView4();
		Container cp= getContentPane();
		cp.add(pv, BorderLayout.CENTER);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we){
				closeIntfcKit();
			}
		});
	}

	private void openIntfcKit() {
		try {
			interfaceKit = new InterfaceKitPhidget();
			interfaceKit.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
					System.out.println("Error event for " + ee);
				}
			});
			interfaceKit.addSensorChangeListener(new SensorChangeListener() {
				public void sensorChanged(SensorChangeEvent se) {
					if ( se.getIndex() == pressureIndex ) 
						pv.updateChart(se.getValue() );
				}
			});
			interfaceKit.openAny();
			System.out.println("Waiting for PressureSensor attachment...");
			interfaceKit.waitForAttachment();
			interfaceKit.setRatiometric(true);
			while (!interfaceKit.getRatiometric());
		} catch (PhidgetException pe) {
			System.err.println(pe);
		}
	}

	private void closeIntfcKit() {
		System.out.println("Closing...");
		try { 
			interfaceKit.close(); }
		catch (PhidgetException pe) { 
			System.err.println(pe); }
		interfaceKit = null;
		System.exit(0);
	}
}